<!DOCTYPE html>
<html lang="en" translate="yes"
    style="--vh: 9.15px; --primary: #247FFF; --bg: #fff; --btn-text: #00ff0a; --bg-tab: #003400; --bg-tabbar: #F9FCFF; --bg-input: #F8F8F8; --btn-bg: linear-gradient(99deg, #96ad22 1%, #96ad22 100%); --bg-card: #F9FCFF; --text-gray: rgba(28, 37, 61, 0.502); --tab-text: #fff; --border-color: #B1CDF0; --placeholder: #636983;">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>ciphermining - Withdraw History</title>
    <meta name="apple-mobile-web-app-title" content="ciphermining">
    <link rel="manifest" href="/manifest.json">

    <!-- All required CSS files from the new design -->
    <link rel="stylesheet" crossorigin="" href="{{asset ('rx/login/assets/login.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/vip/assets/BaseAlarmLogoBtn-B1F5Xzzt.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/vip/assets/default-DdSCmmrV.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/vip/assets/index-nwFgi4pK.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/vip/assets/index-c7An_eE9.css')}}">
    
    <!-- Inline styles to apply the new design and ensure responsiveness -->
    <style>
   #app.a-t-1.no-2 {
    background: #001e00;
    background-size: cover;
    color: var(--btn-text);
    min-height: 100vh; /* Ensures the background covers the full screen height */
}

#app.a-t-1.no-2 .navigation-content:after {
    max-width: var(--maxWidth);
    content: "";
    width: 100%;
    height: calc(var(--vh, 1vh) * 100);
    background: #004500;
    background-size: 100% 100%;
    background-attachment: fixed;
    position: absolute;
    left: 0;
    top: 0;
    z-index: -1;
}
.nav-bar-wrap{
    background: #001e00 !important;
    position: fixed; /* Fixes the header at the top */
    top: 0;
    left: 0;
    right: 0;
    z-index: 100;
}
.tab-bar-wrap {
    position: fixed; /* Fixes the tab bar at the bottom */
    bottom: 0;
    left: 0;
    right: 0;
    z-index: 100;
}
.mining-wrap {
    padding: 15px;
    padding-top: 70px; /* Increased padding to avoid overlap with the fixed header */
    padding-bottom: 100px; /* To avoid overlap with tab bar */
}
.mining-wrap-card {
    background-color: #ffffff14;
    border: 1px solid #96ad22;
    margin-bottom: 15px;
}
.name-text {
    color: #fff;
}
.info-item-value-left, .info-item-value-right {
    color: #fff;
}
.info-item-value-right {
    color: var(--btn-text);
    font-weight: bold;
}
</style>
</head>

<body>
    <div id="app" data-v-app="" class="a-t-1 no-2">
        <div class="box-border w-full">
            
            <!-- Header that matches the screenshot -->
            <nav class="nav-bar-wrap is-scroll-state" style="--6aac73fb: 1;">
                <div class="nav-bar">
                    <div id="navBarItem" class="nav-bar-content h-full w-full">
                        <div class="left">
                            <p class="name font-ali" style="font-size: 20px;">ciphermining</p>
                        </div>
                        <div class="right">
                            <div class="cursor-pointer">
                                <div class="w-lang-label flex items-center">
                                    <div class="i-ic:sharp-language w-20px h-20px mr-4px"></div>
                                    <span>English</span>
                                </div>
                            </div>
                            <div class="rotate base-alarm-logo-btn cursor-pointer mr-0! ml-8px rd-$btn-radius!">
                                <div class="i-solar:bell-bold w-20px h-20px"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
            
            <!-- Main Content Area -->
            <div data-v-65581daa="" class="mining-wrap">
                @forelse(\App\Models\Withdrawal::where('user_id', auth()->id())->orderBy('id', 'desc')->get() as $element)
                    <div data-v-65581daa="" class="container-card relative rd-$card-radius p-$mg c-$btn-text mining-wrap-card">
                        <div data-v-65581daa="" class="name">
                            <div data-v-65581daa="" class="name-text">Withdraw</div>
                        </div>
                        <div data-v-65581daa="" class="mining-wrap-card-content">
                            <div data-v-65581daa="" class="info">
                                <div data-v-65581daa="" class="info-item">
                                    <div data-v-65581daa="" class="info-item-value-left">Status</div>
                                    <div data-v-65581daa="" class="info-item-value-right">
                                        @if($element->status == 'approved')
                                            Successful Withdraw
                                        @elseif($element->status == 'pending')
                                            Withdraw Processing
                                        @elseif($element->status == 'rejected')
                                            Withdraw Rejected
                                        @endif
                                    </div>
                                </div>
                                <div data-v-65581daa="" class="info-item">
                                    <div data-v-65581daa="" class="info-item-value-left">Date</div>
                                    <div data-v-65581daa="" class="info-item-value-right">{{$element->created_at}}</div>
                                </div>
                                <div data-v-65581daa="" class="info-item">
                                    <div data-v-65581daa="" class="info-item-value-left">Amount</div>
                                    <div data-v-65581daa="" class="info-item-value-right">{{price($element->amount)}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <!-- This part will be empty if there's no history, matching your screenshot -->
                @endforelse
            </div>
            
            <!-- Tab Bar Navigation -->
            <div class="tab-bar-wrap tab-bar-wrap-1" style="--8820db26: 20%;">
                <div class="tab-bar">
                    <div class="tab-item" onclick="window.location.href='{{route ('dashboard')}}'">
                        <div data-v-12a04aa8="" id="tabItem" class="tab-item-inner">
                            <div data-v-12a04aa8="" class="tab-item-icon i-ph:house-fill c-$text-gray"></div>
                            <div data-v-12a04aa8="" class="tab-item-label">Home</div>
                        </div>
                    </div>
                    <div class="tab-item" onclick="window.location.href='{{route ('vip')}}'">
                        <div data-v-12a04aa8="" id="tabItem" class="tab-item-inner">
                            <div data-v-12a04aa8="" class="tab-item-icon i-majesticons:chip c-$text-gray"></div>
                            <div data-v-12a04aa8="" class="tab-item-label">Mining Pool</div>
                        </div>
                    </div>
                    <div class="tab-item" onclick="window.location.href='{{route ('ordered')}}'">
                        <div data-v-12a04aa8="" id="tabItem" class="tab-item-inner">
                            <div data-v-12a04aa8="" class="tab-item-icon i-icon-park-outline:financing c-$text-gray"></div>
                            <div data-v-12a04aa8="" class="tab-item-label">Income</div>
                        </div>
                    </div>
                    <div class="tab-item" onclick="window.location.href='{{route ('user.team')}}'">
                        <div data-v-12a04aa8="" id="tabItem" class="tab-item-inner">
                            <div data-v-12a04aa8="" class="tab-item-icon i-fluent:people-team-32-filled c-$text-gray"></div>
                            <div data-v-12a04aa8="" class="tab-item-label">Team</div>
                        </div>
                    </div>
                    <div class="tab-item" onclick="window.location.href='{{route ('profile')}}'">
                        <div data-v-12a04aa8="" id="tabItem" class="tab-item-inner">
                            <div data-v-12a04aa8="" class="tab-item-icon i-mingcute:user-3-fill c-$text-gray"></div>
                            <div data-v-12a04aa8="" class="tab-item-label">Me</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('partials.preloader')
</body>
</html>