<!DOCTYPE html>
<html lang="en" translate="yes"
    style="--vh: 9.15px; --primary: #247FFF; --bg: #fff; --btn-text: #00FF0A; --bg-tab: #F9FCFF; --bg-tabbar: #F9FCFF; --bg-input: #F8F8F8; --btn-bg: linear-gradient(99deg, #96ad22 1%, #96ad22 100%); --bg-card: #F9FCFF; --text-gray: rgba(28, 37, 61, 0.502); --tab-text: #fff; --border-color: #B1CDF0; --placeholder: #636983;">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>ciphermining - Choose Payment</title>

    <meta name="apple-mobile-web-app-title" content="ciphermining">

    <!-- All CSS files from the new design -->
    <link rel="stylesheet" crossorigin="" href="https://usdt.ktdev.shop/rx/login/assets/login.css">
    <link rel="stylesheet" href="https://usdt.ktdev.shop/rx/de/assets/BaseAlarmLogoBtn-B1F5Xzzt.css">
    <link rel="stylesheet" href="https://usdt.ktdev.shop/rx/de/assets/default-DdSCmmrV.css">
    <link rel="stylesheet" href="https://usdt.ktdev.shop/rx/de/assets/withdraw-C0uSkFe.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    
    <!-- Inline styles to apply the new design -->
    <style>
       #app.a-t-1.no-2 {
        background: #004500;
        background-size: cover;
        color: var(--btn-text);
    }
    .navigation-content{
        color: white;
    }
    .list-group{
        background-color: #ffffff14;
        border-radius: 8px;
        padding: 10px;
    }
    .list-group-item {
        background: transparent;
        border: none;
        color: #fff;
        padding: 18px 15px;
        font-size: 16px;
    }
    .list-group-item:first-child{
        border-bottom: 1px solid rgba(255,255,255,0.1) !important;
    }
    .checker{
        width: 24px;
        height: 24px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 1px solid #fff;
    }
    .checker i{
        display: none;
    }
    .selected .checker {
        background: #96ad22;
        border-color: #96ad22;
    }
    .selected .checker i {
        display: block;
        color: #fff;
    }
    </style>
</head>

<body>
<div id="app" data-v-app="" class="a-t-1 no-2">
    <div class="box-border w-full">
        <!-- Header from the new design -->
        <div data-v-b5431ff1="" class="navigation" style="">
            <div data-v-b5431ff1="" class="navigation-content">
                Choose Payment Method
                <div data-v-b5431ff1="" class="tools">
                    <div data-v-b5431ff1="" onclick="window.location.href='{{route('user.deposit')}}'" class="icon cursor-pointer i-material-symbols-arrow-back-ios-new-rounded"></div>
                </div>
            </div>
        </div>

        <!-- Main Content Area -->
        <div class="second-wrap p-$mg">
            <div class="container-card relative rd-$card-radius p-$mg c-$btn-text p-14px my-14px" style="background: transparent; padding:0;">
                
                <ul class="list-group">
                    <li class="list-group-item" onclick="goPaymentMethod('bkash')">
                        <div style="display: flex;justify-content: space-between; align-items: center;">
                            <div style="font-weight: bold; display: flex; align-items: center; gap: 15px;">
                                <img style="width: 30px;height: 30px;border-radius: 50px;" src="{{asset('public/b.png')}}" alt=""> bKash
                            </div>
                            <div class="checker bkash"><i class="fa fa-check"></i></div>
                        </div>
                    </li>
                    <li class="list-group-item" onclick="goPaymentMethod('nagad')">
                        <div style="display: flex;justify-content: space-between; align-items: center;">
                            <div style="font-weight: bold; display: flex; align-items: center; gap: 15px;">
                                <img style="width: 30px;height: 30px;border-radius: 50px;" src="{{asset('public/n.jpeg')}}" alt=""> Nagad
                            </div>
                            <div class="checker nagad"><i class="fa fa-check"></i></div>
                        </div>
                    </li>
                </ul>

                <a href="javascript:void(0)" onclick="goPa()" class="base-main-btn flex items-center justify-center mt-20px!">
                    <div class="base-main-btn-content">
                        Confirm
                    </div>
                </a>
            </div>

            <input type="hidden" name="method" value="">
        </div>
    </div>
</div>

<script>
    function goPaymentMethod(method){
        let nagadItem = document.querySelector('.nagad').closest('.list-group-item');
        let bkashItem = document.querySelector('.bkash').closest('.list-group-item');
        
        // Reset both
        bkashItem.classList.remove('selected');
        nagadItem.classList.remove('selected');

        if (method == 'bkash'){
            bkashItem.classList.add('selected');
            document.querySelector('input[name="method"]').value = 'bkash';
        }
        if (method == 'nagad'){
            nagadItem.classList.add('selected');
            document.querySelector('input[name="method"]').value = 'nagad';
        }
    }

    function goPa(){
        let method = document.querySelector('input[name="method"]').value;
        if (method != ''){
            window.location.href = '{{url('/payment-confirmation')}}'+'/'+method+'/'+'{{$amount}}';
        }else {
            // You can use a more modern alert/toast notification if you have one
            alert('Please select a payment method');
        }
    }
</script>

</body>
</html>