
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>About Us - Green City</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        html {
            scroll-behavior: smooth;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #0A1412;
            /* Dark Green background */
            color: #E2E8F0;
        }

        .header-bg {
            background-image: linear-gradient(to bottom, rgba(10, 20, 18, 0.8), rgba(10, 20, 18, 1)), url('https://images.unsplash.com/photo-1508013861974-9f6347163ebe?q=80&w=2070&auto=format&fit=crop');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
        }

        .card {
            background-color: rgba(20, 48, 42, 0.5);
            border: 1px solid rgba(0, 168, 107, 0.2);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            transition: all 0.3s ease;
            box-shadow: inset 0 0 10px rgba(0, 168, 107, 0.1), 0 5px 15px rgba(0,0,0,0.2);
        }

        .card:hover {
            border-color: rgba(0, 168, 107, 0.7);
            transform: translateY(-8px);
            box-shadow: inset 0 0 15px rgba(0, 168, 107, 0.3), 0 10px 30px rgba(0, 0, 0, 0.4);
        }

        .cta-button {
            background: #00A86B; /* Jade Green */
            box-shadow: 0 4px 20px rgba(0, 168, 107, 0.3);
            transition: all 0.3s ease;
        }

        .cta-button:hover {
            box-shadow: 0 6px 25px rgba(0, 168, 107, 0.5);
            transform: scale(1.05);
        }

        .outline-button {
            border: 2px solid #00A86B;
            color: #00A86B;
            transition: all 0.3s ease;
        }
        
        .outline-button:hover {
            background-color: #00A86B;
            color: #FFFFFF;
        }

        /* Timeline Styles */
        .timeline-item {
            position: relative;
            padding-left: 40px;
            padding-bottom: 40px;
        }

        .timeline-item:last-child {
            padding-bottom: 0;
        }

        .timeline-item::before {
            content: '';
            position: absolute;
            left: 11px;
            top: 5px;
            width: 2px;
            height: 100%;
            background-color: rgba(0, 168, 107, 0.3);
        }
        
        .timeline-item:last-child::before {
           height: 0;
        }

        .timeline-dot {
            position: absolute;
            left: 0;
            top: 5px;
            height: 24px;
            width: 24px;
            border-radius: 50%;
            background-color: #00A86B;
            border: 4px solid #0A1412;
            z-index: 10;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-in {
            animation: fadeIn 0.8s ease-out forwards;
            opacity: 0;
        }
    </style>
</head>

<body class="antialiased">

    <!-- Navbar -->
    <nav class="bg-black/30 backdrop-blur-md fixed top-0 left-0 right-0 z-50">
        <div class="max-w-sm mx-auto px-4 py-3 flex justify-between items-center">
            <a href="#" class="text-xl font-bold text-white flex items-center gap-2">
                <i class="fas fa-leaf text-[#00A86B]"></i>
                <span>Green City</span>
            </a>
            <a href="#join-us" class="cta-button text-white font-semibold py-2 px-4 rounded-lg text-sm">
                Get Started
            </a>
        </div>
    </nav>


    <!-- Header Section -->
    <header class="header-bg pt-40 pb-24 text-white text-center">
        <div class="max-w-sm mx-auto px-4">
            <h1 class="text-4xl font-extrabold tracking-tight leading-tight fade-in" style="animation-delay: 0.2s;">About Green City</h1>
            <p class="mt-4 text-lg text-slate-300 fade-in" style="animation-delay: 0.4s;">Building a sustainable future where nature and profit grow together.</p>
        </div>
    </header>

    <main class="max-w-sm mx-auto px-4 py-16 space-y-20">

        <!-- Mission & Vision Section -->
        <section class="grid grid-cols-1 gap-12 items-center fade-in" style="animation-delay: 0.6s;">
            <div class="space-y-4">
                <h2 class="text-3xl font-bold text-white"><span class="text-[#00A86B]">Our</span> <span class="font-serif italic font-normal">Mission</span></h2>
                <div class="border-l-4 border-[#00A86B] pl-4 py-2 bg-black/20 rounded-r-md">
                    <p class="text-slate-300 leading-relaxed">
                        Our mission is to foster a global community dedicated to sustainable investments. We focus on protecting our planet's precious ecosystems, advancing green energy solutions, and ensuring that every investment contributes positively to a healthier, more sustainable world for future generations.
                    </p>
                </div>
            </div>
            <div class="space-y-4">
                <h2 class="text-3xl font-bold text-white"><span class="text-[#00A86B]">Our</span> <span class="font-serif italic font-normal">Vision</span></h2>
                <div class="border-l-4 border-[#00A86B] pl-4 py-2 bg-black/20 rounded-r-md">
                    <p class="text-slate-300 leading-relaxed">
                        We envision a future where cities are smart, green, and futuristic—powered by renewable energy and built in harmony with nature. Our goal is to create urban environments that are not only technologically advanced and economically prosperous but also serve as models of ecological balance.
                    </p>
                </div>
            </div>
        </section>

        <!-- Core Values Section -->
        <section class="fade-in" style="animation-delay: 0.8s;">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-white">Our Core Values</h2>
                <p class="mt-2 text-slate-400">The principles that guide our work.</p>
            </div>
            <div class="grid grid-cols-1 gap-8">
                <!-- Value Card 1 -->
                <div class="card p-8 rounded-2xl text-center">
                    <i class="fas fa-leaf text-4xl text-[#00A86B] mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Sustainability</h3>
                    <p class="text-slate-400 text-sm">Placing environmental health at the core of all our investment strategies.</p>
                </div>
                <!-- Value Card 2 -->
                <div class="card p-8 rounded-2xl text-center">
                    <i class="fas fa-handshake-angle text-4xl text-[#00A86B] mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Trust & Transparency</h3>
                    <p class="text-slate-400 text-sm">Building lasting relationships with our investors through honesty and clarity.</p>
                </div>
                <!-- Value Card 3 -->
                <div class="card p-8 rounded-2xl text-center">
                    <i class="fas fa-seedling text-4xl text-[#00A86B] mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Eco-friendly Growth</h3>
                    <p class="text-slate-400 text-sm">Ensuring that financial growth and ecological responsibility go hand-in-hand.</p>
                </div>
                <!-- Value Card 4 -->
                <div class="card p-8 rounded-2xl text-center">
                    <i class="fas fa-chart-line text-4xl text-[#00A86B] mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Profitable Investment</h3>
                    <p class="text-slate-400 text-sm">Delivering competitive returns by investing in the future of our planet.</p>
                </div>
            </div>
        </section>

        <!-- Team Section -->
        <section class="fade-in" style="animation-delay: 1s;">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-white">Meet Our Team</h2>
                <p class="mt-2 text-slate-400">The passionate minds behind Green City.</p>
            </div>
            <div class="grid grid-cols-1 gap-8">
                <!-- Team Member 1 -->
                <div class="card rounded-2xl overflow-hidden text-center p-6">
                    <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?q=80&w=400&auto=format&fit=crop" alt="Photo of Jane Doe" class="w-32 h-32 rounded-full mx-auto mb-4 border-4 border-gray-700 object-cover">
                    <h3 class="text-xl font-bold text-white">Jane Doe</h3>
                    <p class="text-[#00A86B] font-semibold">CEO & Co-Founder</p>
                </div>
                <!-- Team Member 2 -->
                <div class="card rounded-2xl overflow-hidden text-center p-6">
                    <img src="https://images.unsplash.com/photo-1539571696357-5a69c17a67c6?q=80&w=400&auto=format&fit=crop" alt="Photo of John Smith" class="w-32 h-32 rounded-full mx-auto mb-4 border-4 border-gray-700 object-cover">
                    <h3 class="text-xl font-bold text-white">John Smith</h3>
                    <p class="text-[#00A86B] font-semibold">Chief Investment Officer</p>
                </div>
                <!-- Team Member 3 -->
                <div class="card rounded-2xl overflow-hidden text-center p-6">
                    <img src="https://images.unsplash.com/photo-1580489944761-15a19d654956?q=80&w=400&auto=format&fit=crop" alt="Photo of Anna Williams" class="w-32 h-32 rounded-full mx-auto mb-4 border-4 border-gray-700 object-cover">
                    <h3 class="text-xl font-bold text-white">Anna Williams</h3>
                    <p class="text-[#00A86B] font-semibold">Head of Sustainability</p>
                </div>
                <!-- Team Member 4 -->
                <div class="card rounded-2xl overflow-hidden text-center p-6">
                    <img src="https://images.unsplash.com/photo-1568602471122-7832951cc4c5?q=80&w=400&auto=format&fit=crop" alt="Photo of Michael Brown" class="w-32 h-32 rounded-full mx-auto mb-4 border-4 border-gray-700 object-cover">
                    <h3 class="text-xl font-bold text-white">Michael Brown</h3>
                    <p class="text-[#00A86B] font-semibold">Lead Project Manager</p>
                </div>
            </div>
        </section>

        <!-- Timeline / Journey Section -->
        <section class="mx-auto fade-in" style="animation-delay: 1.2s;">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-white">Our Journey</h2>
                <p class="mt-2 text-slate-400">Key milestones in our history.</p>
            </div>
            <div>
                <!-- Timeline Item 1 -->
                <div class="timeline-item">
                    <div class="timeline-dot"></div>
                    <h3 class="text-xl font-bold text-[#00A86B]">2022 - The Beginning</h3>
                    <p class="text-slate-300 mt-1">Green City was founded with a vision to revolutionize the investment landscape by integrating profitability with planetary well-being.</p>
                </div>
                <!-- Timeline Item 2 -->
                <div class="timeline-item">
                    <div class="timeline-dot"></div>
                    <h3 class="text-xl font-bold text-[#00A86B]">2023 - Growth & Community</h3>
                    <p class="text-slate-300 mt-1">Over 5,000 conscious investors joined our platform, forming a strong community dedicated to making a positive impact.</p>
                </div>
                <!-- Timeline Item 3 -->
                <div class="timeline-item">
                    <div class="timeline-dot"></div>
                    <h3 class="text-xl font-bold text-[#00A86B]">2024 - Project Launch</h3>
                    <p class="text-slate-300 mt-1">Launched our flagship "Solar River" project, a large-scale renewable energy initiative aimed at powering 10,000 homes.</p>
                </div>
                 <!-- Timeline Item 4 -->
                 <div class="timeline-item">
                    <div class="timeline-dot"></div>
                    <h3 class="text-xl font-bold text-[#00A86B]">Future - Global Impact</h3>
                    <p class="text-slate-300 mt-1">We are expanding our portfolio to include projects in reforestation, clean water access, and sustainable agriculture across the globe.</p>
                </div>
            </div>
        </section>

        <!-- Call to Action Section -->
        <section id="join-us" class="bg-gradient-to-br from-[#00A86B] to-[#008F7A] rounded-2xl p-8 text-center fade-in relative overflow-hidden" style="animation-delay: 1.4s;">
            <div class="absolute -top-4 -left-4 w-24 h-24 bg-white/5 rounded-full"></div>
            <div class="absolute -bottom-8 -right-8 w-32 h-32 border-4 border-white/10 rounded-full"></div>
            
            <div class="relative z-10">
                <h2 class="text-3xl font-extrabold text-white">Join Us in Building a Sustainable Future</h2>
                <p class="text-lg mt-4 mb-8 max-w-2xl mx-auto text-white/90">Become a part of the movement that invests in a greener, more prosperous planet.</p>
                <div class="flex flex-col justify-center items-center gap-4">
                    <a href="https://usdt.ktdev.shop/vip" class="block bg-white text-[#0A1412] font-bold py-3 px-8 rounded-lg w-full transition-transform transform hover:scale-105 shadow-lg">Invest Now</a>
                    <button id="contact-btn" type="button" class="border-2 border-white/80 text-white font-bold py-3 px-8 rounded-lg w-full transition-all hover:bg-white hover:text-[#0A1412]">Contact Us</button>
                </div>
            </div>
        </section>
    </main>

    <!-- Contact Modal -->
    <div id="contact-modal" class="fixed inset-0 bg-black/70 backdrop-blur-sm items-center justify-center z-[100] hidden">
        <div class="card rounded-2xl p-8 w-full max-w-xs mx-4 relative text-center">
            <button id="close-modal-btn" class="absolute top-4 right-4 text-slate-400 hover:text-white transition-colors">
                <i class="fas fa-times text-2xl"></i>
            </button>
            <h3 class="text-2xl font-bold text-white mb-4">Contact Us</h3>
            <p class="text-slate-300 mb-6">
                Have questions? Our team is ready to help. Join our community channels for support.
            </p>
            <div class="flex flex-col gap-4">
                <a href="https://t.me/kt_devloper" target="_blank" class="flex items-center justify-center gap-3 bg-[#2AABEE] text-white font-bold py-3 px-6 rounded-lg w-full transition-transform transform hover:scale-105">
                    <i class="fab fa-telegram-plane"></i>
                    <span>Join on Telegram</span>
                </a>
                <a href="https://t.me/kt_devloper" target="_blank" class="flex items-center justify-center gap-3 bg-[#25D366] text-white font-bold py-3 px-6 rounded-lg w-full transition-transform transform hover:scale-105">
                    <i class="fab fa-whatsapp"></i>
                    <span>Chat on WhatsApp</span>
                </a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const contactButton = document.getElementById('contact-btn');
            const contactModal = document.getElementById('contact-modal');
            const closeModalButton = document.getElementById('close-modal-btn');

            // Function to show the modal
            const showModal = () => {
                contactModal.classList.remove('hidden');
                contactModal.classList.add('flex');
            };

            // Function to hide the modal
            const hideModal = () => {
                contactModal.classList.add('hidden');
                contactModal.classList.remove('flex');
            };

            // Event listeners
            contactButton.addEventListener('click', showModal);
            closeModalButton.addEventListener('click', hideModal);

            // Close modal when clicking on the overlay
            contactModal.addEventListener('click', (event) => {
                if (event.target === contactModal) {
                    hideModal();
                }
            });
        });
    </script>

</body>
</html>


