<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Admin;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserLedger;
use Carbon\Carbon;

class DailySalary extends Command
{
    protected $signature = 'salary:daily';
    protected $description = 'Automatically add daily income to users';

    public function handle()
    {
        $admin = Admin::first();

        // আজকের salary দেওয়া হয়ে গেলে আর দিবে না
        if ($admin->salary_date == date('Y-m-d')) {
            $this->info("Salary already served today!");
            return;
        }

        // Active purchases process
        Purchase::where('status', 'active')->chunk(100, function ($purchases) {
            foreach ($purchases as $purchase) {
                $user = User::find($purchase->user_id);
                if ($user) {
                    $user->receive_able_amount += $purchase->daily_income;
                    $user->save();

                    // Ledger entry
                    $ledger = new UserLedger();
                    $ledger->user_id = $user->id;
                    $ledger->reason = 'daily_income';
                    $ledger->perticulation = 'Daily Income Added';
                    $ledger->amount = $purchase->daily_income;
                    $ledger->credit = $purchase->daily_income;
                    $ledger->status = 'approved';
                    $ledger->date = now();
                    $ledger->save();

                    // Package validity check
                    $checkExpire = new Carbon($purchase->validity);
                    if ($checkExpire->isPast()) {
                        $purchase->status = 'inactive';
                        $purchase->save();
                    }
                }
            }
        });

        // Admin salary_date update
        $admin->salary_date = date('Y-m-d');
        $admin->save();

        $this->info("Daily Salary processed successfully!");
    }
}
